package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  ClientRequestToken,
  Percent
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartContentModerationRequest(
    video: zio.aws.rekognition.model.Video,
    minConfidence: Option[Percent] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    notificationChannel: Option[zio.aws.rekognition.model.NotificationChannel] =
      None,
    jobTag: Option[JobTag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest = {
    import StartContentModerationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartContentModerationRequest.ReadOnly =
    zio.aws.rekognition.model.StartContentModerationRequest
      .wrap(buildAwsValue())
}
object StartContentModerationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartContentModerationRequest =
      zio.aws.rekognition.model.StartContentModerationRequest(
        video.asEditable,
        minConfidence.map(value => value),
        clientRequestToken.map(value => value),
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def minConfidence: Option[Percent]
    def clientRequestToken: Option[ClientRequestToken]
    def notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Option[JobTag]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest
  ) extends zio.aws.rekognition.model.StartContentModerationRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val minConfidence: Option[Percent] = scala
      .Option(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ClientRequestToken(value)
      )
    override val notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly] = scala
      .Option(impl.notificationChannel())
      .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Option[JobTag] = scala
      .Option(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest
  ): zio.aws.rekognition.model.StartContentModerationRequest.ReadOnly =
    new Wrapper(impl)
}
