package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Timecode, ULong, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SegmentDetection(
    `type`: Option[zio.aws.rekognition.model.SegmentType] = None,
    startTimestampMillis: Option[Timestamp] = None,
    endTimestampMillis: Option[Timestamp] = None,
    durationMillis: Option[ULong] = None,
    startTimecodeSMPTE: Option[Timecode] = None,
    endTimecodeSMPTE: Option[Timecode] = None,
    durationSMPTE: Option[Timecode] = None,
    technicalCueSegment: Option[zio.aws.rekognition.model.TechnicalCueSegment] =
      None,
    shotSegment: Option[zio.aws.rekognition.model.ShotSegment] = None,
    startFrameNumber: Option[ULong] = None,
    endFrameNumber: Option[ULong] = None,
    durationFrames: Option[ULong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SegmentDetection = {
    import SegmentDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SegmentDetection
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        startTimestampMillis.map(value =>
          Timestamp.unwrap(value): java.lang.Long
        )
      )(_.startTimestampMillis)
      .optionallyWith(
        endTimestampMillis.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.endTimestampMillis)
      .optionallyWith(
        durationMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.durationMillis)
      .optionallyWith(
        startTimecodeSMPTE.map(value =>
          Timecode.unwrap(value): java.lang.String
        )
      )(_.startTimecodeSMPTE)
      .optionallyWith(
        endTimecodeSMPTE.map(value => Timecode.unwrap(value): java.lang.String)
      )(_.endTimecodeSMPTE)
      .optionallyWith(
        durationSMPTE.map(value => Timecode.unwrap(value): java.lang.String)
      )(_.durationSMPTE)
      .optionallyWith(technicalCueSegment.map(value => value.buildAwsValue()))(
        _.technicalCueSegment
      )
      .optionallyWith(shotSegment.map(value => value.buildAwsValue()))(
        _.shotSegment
      )
      .optionallyWith(
        startFrameNumber.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.startFrameNumber)
      .optionallyWith(
        endFrameNumber.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.endFrameNumber)
      .optionallyWith(
        durationFrames.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.durationFrames)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SegmentDetection.ReadOnly =
    zio.aws.rekognition.model.SegmentDetection.wrap(buildAwsValue())
}
object SegmentDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SegmentDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SegmentDetection =
      zio.aws.rekognition.model.SegmentDetection(
        `type`.map(value => value),
        startTimestampMillis.map(value => value),
        endTimestampMillis.map(value => value),
        durationMillis.map(value => value),
        startTimecodeSMPTE.map(value => value),
        endTimecodeSMPTE.map(value => value),
        durationSMPTE.map(value => value),
        technicalCueSegment.map(value => value.asEditable),
        shotSegment.map(value => value.asEditable),
        startFrameNumber.map(value => value),
        endFrameNumber.map(value => value),
        durationFrames.map(value => value)
      )
    def `type`: Option[zio.aws.rekognition.model.SegmentType]
    def startTimestampMillis: Option[Timestamp]
    def endTimestampMillis: Option[Timestamp]
    def durationMillis: Option[ULong]
    def startTimecodeSMPTE: Option[Timecode]
    def endTimecodeSMPTE: Option[Timecode]
    def durationSMPTE: Option[Timecode]
    def technicalCueSegment
        : Option[zio.aws.rekognition.model.TechnicalCueSegment.ReadOnly]
    def shotSegment: Option[zio.aws.rekognition.model.ShotSegment.ReadOnly]
    def startFrameNumber: Option[ULong]
    def endFrameNumber: Option[ULong]
    def durationFrames: Option[ULong]
    def getType: ZIO[Any, AwsError, zio.aws.rekognition.model.SegmentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStartTimestampMillis: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimestampMillis", startTimestampMillis)
    def getEndTimestampMillis: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimestampMillis", endTimestampMillis)
    def getDurationMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getStartTimecodeSMPTE: ZIO[Any, AwsError, Timecode] =
      AwsError.unwrapOptionField("startTimecodeSMPTE", startTimecodeSMPTE)
    def getEndTimecodeSMPTE: ZIO[Any, AwsError, Timecode] =
      AwsError.unwrapOptionField("endTimecodeSMPTE", endTimecodeSMPTE)
    def getDurationSMPTE: ZIO[Any, AwsError, Timecode] =
      AwsError.unwrapOptionField("durationSMPTE", durationSMPTE)
    def getTechnicalCueSegment: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.TechnicalCueSegment.ReadOnly
    ] = AwsError.unwrapOptionField("technicalCueSegment", technicalCueSegment)
    def getShotSegment
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ShotSegment.ReadOnly] =
      AwsError.unwrapOptionField("shotSegment", shotSegment)
    def getStartFrameNumber: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("startFrameNumber", startFrameNumber)
    def getEndFrameNumber: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("endFrameNumber", endFrameNumber)
    def getDurationFrames: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("durationFrames", durationFrames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SegmentDetection
  ) extends zio.aws.rekognition.model.SegmentDetection.ReadOnly {
    override val `type`: Option[zio.aws.rekognition.model.SegmentType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.rekognition.model.SegmentType.wrap(value))
    override val startTimestampMillis: Option[Timestamp] = scala
      .Option(impl.startTimestampMillis())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val endTimestampMillis: Option[Timestamp] = scala
      .Option(impl.endTimestampMillis())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val durationMillis: Option[ULong] = scala
      .Option(impl.durationMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val startTimecodeSMPTE: Option[Timecode] = scala
      .Option(impl.startTimecodeSMPTE())
      .map(value => zio.aws.rekognition.model.primitives.Timecode(value))
    override val endTimecodeSMPTE: Option[Timecode] = scala
      .Option(impl.endTimecodeSMPTE())
      .map(value => zio.aws.rekognition.model.primitives.Timecode(value))
    override val durationSMPTE: Option[Timecode] = scala
      .Option(impl.durationSMPTE())
      .map(value => zio.aws.rekognition.model.primitives.Timecode(value))
    override val technicalCueSegment
        : Option[zio.aws.rekognition.model.TechnicalCueSegment.ReadOnly] = scala
      .Option(impl.technicalCueSegment())
      .map(value => zio.aws.rekognition.model.TechnicalCueSegment.wrap(value))
    override val shotSegment
        : Option[zio.aws.rekognition.model.ShotSegment.ReadOnly] = scala
      .Option(impl.shotSegment())
      .map(value => zio.aws.rekognition.model.ShotSegment.wrap(value))
    override val startFrameNumber: Option[ULong] = scala
      .Option(impl.startFrameNumber())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val endFrameNumber: Option[ULong] = scala
      .Option(impl.endFrameNumber())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val durationFrames: Option[ULong] = scala
      .Option(impl.durationFrames())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SegmentDetection
  ): zio.aws.rekognition.model.SegmentDetection.ReadOnly = new Wrapper(impl)
}
