package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.FaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchFacesResponse(
    searchedFaceId: Option[FaceId] = None,
    faceMatches: Option[Iterable[zio.aws.rekognition.model.FaceMatch]] = None,
    faceModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchFacesResponse = {
    import SearchFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
      .builder()
      .optionallyWith(
        searchedFaceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.searchedFaceId)
      .optionallyWith(
        faceMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceMatches)
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchFacesResponse.ReadOnly =
    zio.aws.rekognition.model.SearchFacesResponse.wrap(buildAwsValue())
}
object SearchFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchFacesResponse =
      zio.aws.rekognition.model.SearchFacesResponse(
        searchedFaceId.map(value => value),
        faceMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        faceModelVersion.map(value => value)
      )
    def searchedFaceId: Option[FaceId]
    def faceMatches: Option[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]]
    def faceModelVersion: Option[String]
    def getSearchedFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("searchedFaceId", searchedFaceId)
    def getFaceMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("faceMatches", faceMatches)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
  ) extends zio.aws.rekognition.model.SearchFacesResponse.ReadOnly {
    override val searchedFaceId: Option[FaceId] = scala
      .Option(impl.searchedFaceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
    override val faceMatches
        : Option[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]] = scala
      .Option(impl.faceMatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.FaceMatch.wrap(item)
        }.toList
      )
    override val faceModelVersion: Option[String] =
      scala.Option(impl.faceModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
  ): zio.aws.rekognition.model.SearchFacesResponse.ReadOnly = new Wrapper(impl)
}
