package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.UInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProtectiveEquipmentSummary(
    personsWithRequiredEquipment: Option[Iterable[UInteger]] = None,
    personsWithoutRequiredEquipment: Option[Iterable[UInteger]] = None,
    personsIndeterminate: Option[Iterable[UInteger]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary = {
    import ProtectiveEquipmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
      .builder()
      .optionallyWith(
        personsWithRequiredEquipment.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.personsWithRequiredEquipment)
      .optionallyWith(
        personsWithoutRequiredEquipment.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.personsWithoutRequiredEquipment)
      .optionallyWith(
        personsIndeterminate.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.personsIndeterminate)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly =
    zio.aws.rekognition.model.ProtectiveEquipmentSummary.wrap(buildAwsValue())
}
object ProtectiveEquipmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProtectiveEquipmentSummary =
      zio.aws.rekognition.model.ProtectiveEquipmentSummary(
        personsWithRequiredEquipment.map(value => value),
        personsWithoutRequiredEquipment.map(value => value),
        personsIndeterminate.map(value => value)
      )
    def personsWithRequiredEquipment: Option[List[UInteger]]
    def personsWithoutRequiredEquipment: Option[List[UInteger]]
    def personsIndeterminate: Option[List[UInteger]]
    def getPersonsWithRequiredEquipment: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField(
        "personsWithRequiredEquipment",
        personsWithRequiredEquipment
      )
    def getPersonsWithoutRequiredEquipment: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField(
        "personsWithoutRequiredEquipment",
        personsWithoutRequiredEquipment
      )
    def getPersonsIndeterminate: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField("personsIndeterminate", personsIndeterminate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
  ) extends zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly {
    override val personsWithRequiredEquipment: Option[List[UInteger]] = scala
      .Option(impl.personsWithRequiredEquipment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.UInteger(item)
        }.toList
      )
    override val personsWithoutRequiredEquipment: Option[List[UInteger]] = scala
      .Option(impl.personsWithoutRequiredEquipment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.UInteger(item)
        }.toList
      )
    override val personsIndeterminate: Option[List[UInteger]] = scala
      .Option(impl.personsIndeterminate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.UInteger(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
  ): zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly =
    new Wrapper(impl)
}
