package zio.aws.rekognition.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  DateTime,
  ULong,
  KmsKeyId,
  InferenceUnits,
  StatusMessage,
  ProjectVersionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProjectVersionDescription(
    projectVersionArn: Option[ProjectVersionArn] = None,
    creationTimestamp: Option[DateTime] = None,
    minInferenceUnits: Option[InferenceUnits] = None,
    status: Option[zio.aws.rekognition.model.ProjectVersionStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    billableTrainingTimeInSeconds: Option[ULong] = None,
    trainingEndTimestamp: Option[DateTime] = None,
    outputConfig: Option[zio.aws.rekognition.model.OutputConfig] = None,
    trainingDataResult: Option[zio.aws.rekognition.model.TrainingDataResult] =
      None,
    testingDataResult: Option[zio.aws.rekognition.model.TestingDataResult] =
      None,
    evaluationResult: Option[zio.aws.rekognition.model.EvaluationResult] = None,
    manifestSummary: Option[zio.aws.rekognition.model.GroundTruthManifest] =
      None,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription = {
    import ProjectVersionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
      .builder()
      .optionallyWith(
        projectVersionArn.map(value =>
          ProjectVersionArn.unwrap(value): java.lang.String
        )
      )(_.projectVersionArn)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        minInferenceUnits.map(value => InferenceUnits.unwrap(value): Integer)
      )(_.minInferenceUnits)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        billableTrainingTimeInSeconds.map(value =>
          ULong.unwrap(value): java.lang.Long
        )
      )(_.billableTrainingTimeInSeconds)
      .optionallyWith(
        trainingEndTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.trainingEndTimestamp)
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(trainingDataResult.map(value => value.buildAwsValue()))(
        _.trainingDataResult
      )
      .optionallyWith(testingDataResult.map(value => value.buildAwsValue()))(
        _.testingDataResult
      )
      .optionallyWith(evaluationResult.map(value => value.buildAwsValue()))(
        _.evaluationResult
      )
      .optionallyWith(manifestSummary.map(value => value.buildAwsValue()))(
        _.manifestSummary
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly =
    zio.aws.rekognition.model.ProjectVersionDescription.wrap(buildAwsValue())
}
object ProjectVersionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProjectVersionDescription =
      zio.aws.rekognition.model.ProjectVersionDescription(
        projectVersionArn.map(value => value),
        creationTimestamp.map(value => value),
        minInferenceUnits.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        billableTrainingTimeInSeconds.map(value => value),
        trainingEndTimestamp.map(value => value),
        outputConfig.map(value => value.asEditable),
        trainingDataResult.map(value => value.asEditable),
        testingDataResult.map(value => value.asEditable),
        evaluationResult.map(value => value.asEditable),
        manifestSummary.map(value => value.asEditable),
        kmsKeyId.map(value => value)
      )
    def projectVersionArn: Option[ProjectVersionArn]
    def creationTimestamp: Option[DateTime]
    def minInferenceUnits: Option[InferenceUnits]
    def status: Option[zio.aws.rekognition.model.ProjectVersionStatus]
    def statusMessage: Option[StatusMessage]
    def billableTrainingTimeInSeconds: Option[ULong]
    def trainingEndTimestamp: Option[DateTime]
    def outputConfig: Option[zio.aws.rekognition.model.OutputConfig.ReadOnly]
    def trainingDataResult
        : Option[zio.aws.rekognition.model.TrainingDataResult.ReadOnly]
    def testingDataResult
        : Option[zio.aws.rekognition.model.TestingDataResult.ReadOnly]
    def evaluationResult
        : Option[zio.aws.rekognition.model.EvaluationResult.ReadOnly]
    def manifestSummary
        : Option[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly]
    def kmsKeyId: Option[KmsKeyId]
    def getProjectVersionArn: ZIO[Any, AwsError, ProjectVersionArn] =
      AwsError.unwrapOptionField("projectVersionArn", projectVersionArn)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getMinInferenceUnits: ZIO[Any, AwsError, InferenceUnits] =
      AwsError.unwrapOptionField("minInferenceUnits", minInferenceUnits)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ProjectVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getBillableTrainingTimeInSeconds: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField(
        "billableTrainingTimeInSeconds",
        billableTrainingTimeInSeconds
      )
    def getTrainingEndTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("trainingEndTimestamp", trainingEndTimestamp)
    def getOutputConfig
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OutputConfig.ReadOnly] =
      AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getTrainingDataResult: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.TrainingDataResult.ReadOnly
    ] = AwsError.unwrapOptionField("trainingDataResult", trainingDataResult)
    def getTestingDataResult: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.TestingDataResult.ReadOnly
    ] = AwsError.unwrapOptionField("testingDataResult", testingDataResult)
    def getEvaluationResult: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.EvaluationResult.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationResult", evaluationResult)
    def getManifestSummary: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GroundTruthManifest.ReadOnly
    ] = AwsError.unwrapOptionField("manifestSummary", manifestSummary)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
  ) extends zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly {
    override val projectVersionArn: Option[ProjectVersionArn] = scala
      .Option(impl.projectVersionArn())
      .map(value =>
        zio.aws.rekognition.model.primitives.ProjectVersionArn(value)
      )
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val minInferenceUnits: Option[InferenceUnits] = scala
      .Option(impl.minInferenceUnits())
      .map(value => zio.aws.rekognition.model.primitives.InferenceUnits(value))
    override val status
        : Option[zio.aws.rekognition.model.ProjectVersionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.rekognition.model.ProjectVersionStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val billableTrainingTimeInSeconds: Option[ULong] = scala
      .Option(impl.billableTrainingTimeInSeconds())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val trainingEndTimestamp: Option[DateTime] = scala
      .Option(impl.trainingEndTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val outputConfig
        : Option[zio.aws.rekognition.model.OutputConfig.ReadOnly] = scala
      .Option(impl.outputConfig())
      .map(value => zio.aws.rekognition.model.OutputConfig.wrap(value))
    override val trainingDataResult
        : Option[zio.aws.rekognition.model.TrainingDataResult.ReadOnly] = scala
      .Option(impl.trainingDataResult())
      .map(value => zio.aws.rekognition.model.TrainingDataResult.wrap(value))
    override val testingDataResult
        : Option[zio.aws.rekognition.model.TestingDataResult.ReadOnly] = scala
      .Option(impl.testingDataResult())
      .map(value => zio.aws.rekognition.model.TestingDataResult.wrap(value))
    override val evaluationResult
        : Option[zio.aws.rekognition.model.EvaluationResult.ReadOnly] = scala
      .Option(impl.evaluationResult())
      .map(value => zio.aws.rekognition.model.EvaluationResult.wrap(value))
    override val manifestSummary
        : Option[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly] = scala
      .Option(impl.manifestSummary())
      .map(value => zio.aws.rekognition.model.GroundTruthManifest.wrap(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.rekognition.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
  ): zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly = new Wrapper(
    impl
  )
}
