package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PersonDetection(
    timestamp: Option[Timestamp] = None,
    person: Option[zio.aws.rekognition.model.PersonDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.PersonDetection = {
    import PersonDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.PersonDetection
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(person.map(value => value.buildAwsValue()))(_.person)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.PersonDetection.ReadOnly =
    zio.aws.rekognition.model.PersonDetection.wrap(buildAwsValue())
}
object PersonDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.PersonDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.PersonDetection =
      zio.aws.rekognition.model.PersonDetection(
        timestamp.map(value => value),
        person.map(value => value.asEditable)
      )
    def timestamp: Option[Timestamp]
    def person: Option[zio.aws.rekognition.model.PersonDetail.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getPerson
        : ZIO[Any, AwsError, zio.aws.rekognition.model.PersonDetail.ReadOnly] =
      AwsError.unwrapOptionField("person", person)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.PersonDetection
  ) extends zio.aws.rekognition.model.PersonDetection.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val person
        : Option[zio.aws.rekognition.model.PersonDetail.ReadOnly] = scala
      .Option(impl.person())
      .map(value => zio.aws.rekognition.model.PersonDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.PersonDetection
  ): zio.aws.rekognition.model.PersonDetection.ReadOnly = new Wrapper(impl)
}
