package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Mustache(
    value: Option[Boolean] = None,
    confidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Mustache = {
    import Mustache.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Mustache
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Boolean))(_.value)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Mustache.ReadOnly =
    zio.aws.rekognition.model.Mustache.wrap(buildAwsValue())
}
object Mustache {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Mustache
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Mustache =
      zio.aws.rekognition.model
        .Mustache(value.map(value => value), confidence.map(value => value))
    def value: Option[Boolean]
    def confidence: Option[Percent]
    def getValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("value", value)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Mustache
  ) extends zio.aws.rekognition.model.Mustache.ReadOnly {
    override val value: Option[Boolean] =
      scala.Option(impl.value()).map(value => value: Boolean)
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Mustache
  ): zio.aws.rekognition.model.Mustache.ReadOnly = new Wrapper(impl)
}
