package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MouthOpen(
    value: Option[Boolean] = None,
    confidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.MouthOpen = {
    import MouthOpen.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.MouthOpen
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Boolean))(_.value)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.MouthOpen.ReadOnly =
    zio.aws.rekognition.model.MouthOpen.wrap(buildAwsValue())
}
object MouthOpen {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.MouthOpen
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.MouthOpen =
      zio.aws.rekognition.model
        .MouthOpen(value.map(value => value), confidence.map(value => value))
    def value: Option[Boolean]
    def confidence: Option[Percent]
    def getValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("value", value)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.MouthOpen
  ) extends zio.aws.rekognition.model.MouthOpen.ReadOnly {
    override val value: Option[Boolean] =
      scala.Option(impl.value()).map(value => value: Boolean)
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.MouthOpen
  ): zio.aws.rekognition.model.MouthOpen.ReadOnly = new Wrapper(impl)
}
