package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{
  IsLabeled,
  DatasetArn,
  DatasetLabel,
  HasErrors,
  QueryString,
  ListDatasetEntriesPageSize,
  ExtendedPaginationToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDatasetEntriesRequest(
    datasetArn: DatasetArn,
    containsLabels: Option[Iterable[DatasetLabel]] = None,
    labeled: Option[IsLabeled] = None,
    sourceRefContains: Option[QueryString] = None,
    hasErrors: Option[HasErrors] = None,
    nextToken: Option[ExtendedPaginationToken] = None,
    maxResults: Option[ListDatasetEntriesPageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest = {
    import ListDatasetEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
      .builder()
      .datasetArn(DatasetArn.unwrap(datasetArn): java.lang.String)
      .optionallyWith(
        containsLabels.map(value =>
          value.map { item =>
            DatasetLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containsLabels)
      .optionallyWith(
        labeled.map(value => IsLabeled.unwrap(value): java.lang.Boolean)
      )(_.labeled)
      .optionallyWith(
        sourceRefContains.map(value =>
          QueryString.unwrap(value): java.lang.String
        )
      )(_.sourceRefContains)
      .optionallyWith(
        hasErrors.map(value => HasErrors.unwrap(value): java.lang.Boolean)
      )(_.hasErrors)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListDatasetEntriesPageSize.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListDatasetEntriesRequest.ReadOnly =
    zio.aws.rekognition.model.ListDatasetEntriesRequest.wrap(buildAwsValue())
}
object ListDatasetEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListDatasetEntriesRequest =
      zio.aws.rekognition.model.ListDatasetEntriesRequest(
        datasetArn,
        containsLabels.map(value => value),
        labeled.map(value => value),
        sourceRefContains.map(value => value),
        hasErrors.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def datasetArn: DatasetArn
    def containsLabels: Option[List[DatasetLabel]]
    def labeled: Option[IsLabeled]
    def sourceRefContains: Option[QueryString]
    def hasErrors: Option[HasErrors]
    def nextToken: Option[ExtendedPaginationToken]
    def maxResults: Option[ListDatasetEntriesPageSize]
    def getDatasetArn: ZIO[Any, Nothing, DatasetArn] = ZIO.succeed(datasetArn)
    def getContainsLabels: ZIO[Any, AwsError, List[DatasetLabel]] =
      AwsError.unwrapOptionField("containsLabels", containsLabels)
    def getLabeled: ZIO[Any, AwsError, IsLabeled] =
      AwsError.unwrapOptionField("labeled", labeled)
    def getSourceRefContains: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("sourceRefContains", sourceRefContains)
    def getHasErrors: ZIO[Any, AwsError, HasErrors] =
      AwsError.unwrapOptionField("hasErrors", hasErrors)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListDatasetEntriesPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
  ) extends zio.aws.rekognition.model.ListDatasetEntriesRequest.ReadOnly {
    override val datasetArn: DatasetArn =
      zio.aws.rekognition.model.primitives.DatasetArn(impl.datasetArn())
    override val containsLabels: Option[List[DatasetLabel]] = scala
      .Option(impl.containsLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.DatasetLabel(item)
        }.toList
      )
    override val labeled: Option[IsLabeled] = scala
      .Option(impl.labeled())
      .map(value => zio.aws.rekognition.model.primitives.IsLabeled(value))
    override val sourceRefContains: Option[QueryString] = scala
      .Option(impl.sourceRefContains())
      .map(value => zio.aws.rekognition.model.primitives.QueryString(value))
    override val hasErrors: Option[HasErrors] = scala
      .Option(impl.hasErrors())
      .map(value => zio.aws.rekognition.model.primitives.HasErrors(value))
    override val nextToken: Option[ExtendedPaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
      )
    override val maxResults: Option[ListDatasetEntriesPageSize] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.rekognition.model.primitives.ListDatasetEntriesPageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
  ): zio.aws.rekognition.model.ListDatasetEntriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
