package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, CollectionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListCollectionsResponse(
    collectionIds: Option[Iterable[CollectionId]] = None,
    nextToken: Option[PaginationToken] = None,
    faceModelVersions: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse = {
    import ListCollectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
      .builder()
      .optionallyWith(
        collectionIds.map(value =>
          value.map { item =>
            CollectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.collectionIds)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        faceModelVersions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.faceModelVersions)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly =
    zio.aws.rekognition.model.ListCollectionsResponse.wrap(buildAwsValue())
}
object ListCollectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListCollectionsResponse =
      zio.aws.rekognition.model.ListCollectionsResponse(
        collectionIds.map(value => value),
        nextToken.map(value => value),
        faceModelVersions.map(value => value)
      )
    def collectionIds: Option[List[CollectionId]]
    def nextToken: Option[PaginationToken]
    def faceModelVersions: Option[List[String]]
    def getCollectionIds: ZIO[Any, AwsError, List[CollectionId]] =
      AwsError.unwrapOptionField("collectionIds", collectionIds)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFaceModelVersions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("faceModelVersions", faceModelVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
  ) extends zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly {
    override val collectionIds: Option[List[CollectionId]] = scala
      .Option(impl.collectionIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.CollectionId(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val faceModelVersions: Option[List[String]] = scala
      .Option(impl.faceModelVersions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
  ): zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
