package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LabelDetection(
    timestamp: Option[Timestamp] = None,
    label: Option[zio.aws.rekognition.model.Label] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.LabelDetection = {
    import LabelDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.LabelDetection
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(label.map(value => value.buildAwsValue()))(_.label)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.LabelDetection.ReadOnly =
    zio.aws.rekognition.model.LabelDetection.wrap(buildAwsValue())
}
object LabelDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.LabelDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.LabelDetection =
      zio.aws.rekognition.model.LabelDetection(
        timestamp.map(value => value),
        label.map(value => value.asEditable)
      )
    def timestamp: Option[Timestamp]
    def label: Option[zio.aws.rekognition.model.Label.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getLabel: ZIO[Any, AwsError, zio.aws.rekognition.model.Label.ReadOnly] =
      AwsError.unwrapOptionField("label", label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.LabelDetection
  ) extends zio.aws.rekognition.model.LabelDetection.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val label: Option[zio.aws.rekognition.model.Label.ReadOnly] = scala
      .Option(impl.label())
      .map(value => zio.aws.rekognition.model.Label.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.LabelDetection
  ): zio.aws.rekognition.model.LabelDetection.ReadOnly = new Wrapper(impl)
}
