package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Label(
    name: Option[String] = None,
    confidence: Option[Percent] = None,
    instances: Option[Iterable[zio.aws.rekognition.model.Instance]] = None,
    parents: Option[Iterable[zio.aws.rekognition.model.Parent]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Label = {
    import Label.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Label
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        parents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parents)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Label.ReadOnly =
    zio.aws.rekognition.model.Label.wrap(buildAwsValue())
}
object Label {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Label] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Label =
      zio.aws.rekognition.model.Label(
        name.map(value => value),
        confidence.map(value => value),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parents.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[String]
    def confidence: Option[Percent]
    def instances: Option[List[zio.aws.rekognition.model.Instance.ReadOnly]]
    def parents: Option[List[zio.aws.rekognition.model.Parent.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getParents
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Parent.ReadOnly]] =
      AwsError.unwrapOptionField("parents", parents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Label
  ) extends zio.aws.rekognition.model.Label.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val instances
        : Option[List[zio.aws.rekognition.model.Instance.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Instance.wrap(item)
        }.toList
      )
    override val parents
        : Option[List[zio.aws.rekognition.model.Parent.ReadOnly]] = scala
      .Option(impl.parents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Parent.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Label
  ): zio.aws.rekognition.model.Label.ReadOnly = new Wrapper(impl)
}
