package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTextDetectionResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata] = None,
    textDetections: Option[
      Iterable[zio.aws.rekognition.model.TextDetectionResult]
    ] = None,
    nextToken: Option[PaginationToken] = None,
    textModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse = {
    import GetTextDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        textDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textDetections)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(textModelVersion.map(value => value: java.lang.String))(
        _.textModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetTextDetectionResponse.wrap(buildAwsValue())
}
object GetTextDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetTextDetectionResponse =
      zio.aws.rekognition.model.GetTextDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        textDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        textModelVersion.map(value => value)
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def textDetections
        : Option[List[zio.aws.rekognition.model.TextDetectionResult.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def textModelVersion: Option[String]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getTextDetections: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.TextDetectionResult.ReadOnly
    ]] = AwsError.unwrapOptionField("textDetections", textDetections)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTextModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("textModelVersion", textModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
  ) extends zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly] = scala
      .Option(impl.videoMetadata())
      .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val textDetections
        : Option[List[zio.aws.rekognition.model.TextDetectionResult.ReadOnly]] =
      scala
        .Option(impl.textDetections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.TextDetectionResult.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val textModelVersion: Option[String] =
      scala.Option(impl.textModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
  ): zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
