package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLabelDetectionResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata] = None,
    nextToken: Option[PaginationToken] = None,
    labels: Option[Iterable[zio.aws.rekognition.model.LabelDetection]] = None,
    labelModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse = {
    import GetLabelDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(labelModelVersion.map(value => value: java.lang.String))(
        _.labelModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetLabelDetectionResponse.wrap(buildAwsValue())
}
object GetLabelDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetLabelDetectionResponse =
      zio.aws.rekognition.model.GetLabelDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        nextToken.map(value => value),
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        labelModelVersion.map(value => value)
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def nextToken: Option[PaginationToken]
    def labels: Option[List[zio.aws.rekognition.model.LabelDetection.ReadOnly]]
    def labelModelVersion: Option[String]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLabels: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.LabelDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("labels", labels)
    def getLabelModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("labelModelVersion", labelModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
  ) extends zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly] = scala
      .Option(impl.videoMetadata())
      .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val labels
        : Option[List[zio.aws.rekognition.model.LabelDetection.ReadOnly]] =
      scala
        .Option(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.LabelDetection.wrap(item)
          }.toList
        )
    override val labelModelVersion: Option[String] =
      scala.Option(impl.labelModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
  ): zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
