package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DistributeDataset(arn: DatasetArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DistributeDataset = {
    import DistributeDataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DistributeDataset
      .builder()
      .arn(DatasetArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DistributeDataset.ReadOnly =
    zio.aws.rekognition.model.DistributeDataset.wrap(buildAwsValue())
}
object DistributeDataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DistributeDataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DistributeDataset =
      zio.aws.rekognition.model.DistributeDataset(arn)
    def arn: DatasetArn
    def getArn: ZIO[Any, Nothing, DatasetArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DistributeDataset
  ) extends zio.aws.rekognition.model.DistributeDataset.ReadOnly {
    override val arn: DatasetArn =
      zio.aws.rekognition.model.primitives.DatasetArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DistributeDataset
  ): zio.aws.rekognition.model.DistributeDataset.ReadOnly = new Wrapper(impl)
}
