package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DatasetSource(
    groundTruthManifest: Option[zio.aws.rekognition.model.GroundTruthManifest] =
      None,
    datasetArn: Option[DatasetArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetSource = {
    import DatasetSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetSource
      .builder()
      .optionallyWith(groundTruthManifest.map(value => value.buildAwsValue()))(
        _.groundTruthManifest
      )
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetSource.ReadOnly =
    zio.aws.rekognition.model.DatasetSource.wrap(buildAwsValue())
}
object DatasetSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetSource =
      zio.aws.rekognition.model.DatasetSource(
        groundTruthManifest.map(value => value.asEditable),
        datasetArn.map(value => value)
      )
    def groundTruthManifest
        : Option[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly]
    def datasetArn: Option[DatasetArn]
    def getGroundTruthManifest: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GroundTruthManifest.ReadOnly
    ] = AwsError.unwrapOptionField("groundTruthManifest", groundTruthManifest)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetSource
  ) extends zio.aws.rekognition.model.DatasetSource.ReadOnly {
    override val groundTruthManifest
        : Option[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly] = scala
      .Option(impl.groundTruthManifest())
      .map(value => zio.aws.rekognition.model.GroundTruthManifest.wrap(value))
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.rekognition.model.primitives.DatasetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetSource
  ): zio.aws.rekognition.model.DatasetSource.ReadOnly = new Wrapper(impl)
}
