package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{StatusMessage, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DatasetDescription(
    creationTimestamp: Option[DateTime] = None,
    lastUpdatedTimestamp: Option[DateTime] = None,
    status: Option[zio.aws.rekognition.model.DatasetStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    statusMessageCode: Option[
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = None,
    datasetStats: Option[zio.aws.rekognition.model.DatasetStats] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetDescription = {
    import DatasetDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetDescription
      .builder()
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(statusMessageCode.map(value => value.unwrap))(
        _.statusMessageCode
      )
      .optionallyWith(datasetStats.map(value => value.buildAwsValue()))(
        _.datasetStats
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetDescription.ReadOnly =
    zio.aws.rekognition.model.DatasetDescription.wrap(buildAwsValue())
}
object DatasetDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetDescription =
      zio.aws.rekognition.model.DatasetDescription(
        creationTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        statusMessageCode.map(value => value),
        datasetStats.map(value => value.asEditable)
      )
    def creationTimestamp: Option[DateTime]
    def lastUpdatedTimestamp: Option[DateTime]
    def status: Option[zio.aws.rekognition.model.DatasetStatus]
    def statusMessage: Option[StatusMessage]
    def statusMessageCode
        : Option[zio.aws.rekognition.model.DatasetStatusMessageCode]
    def datasetStats: Option[zio.aws.rekognition.model.DatasetStats.ReadOnly]
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getStatus: ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStatusMessageCode: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = AwsError.unwrapOptionField("statusMessageCode", statusMessageCode)
    def getDatasetStats
        : ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetStats.ReadOnly] =
      AwsError.unwrapOptionField("datasetStats", datasetStats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetDescription
  ) extends zio.aws.rekognition.model.DatasetDescription.ReadOnly {
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val lastUpdatedTimestamp: Option[DateTime] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val status: Option[zio.aws.rekognition.model.DatasetStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.rekognition.model.DatasetStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val statusMessageCode
        : Option[zio.aws.rekognition.model.DatasetStatusMessageCode] = scala
      .Option(impl.statusMessageCode())
      .map(value =>
        zio.aws.rekognition.model.DatasetStatusMessageCode.wrap(value)
      )
    override val datasetStats
        : Option[zio.aws.rekognition.model.DatasetStats.ReadOnly] = scala
      .Option(impl.datasetStats())
      .map(value => zio.aws.rekognition.model.DatasetStats.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetDescription
  ): zio.aws.rekognition.model.DatasetDescription.ReadOnly = new Wrapper(impl)
}
