package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDatasetRequest(
    datasetSource: Option[zio.aws.rekognition.model.DatasetSource] = None,
    datasetType: zio.aws.rekognition.model.DatasetType,
    projectArn: ProjectArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateDatasetRequest
      .builder()
      .optionallyWith(datasetSource.map(value => value.buildAwsValue()))(
        _.datasetSource
      )
      .datasetType(datasetType.unwrap)
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CreateDatasetRequest.ReadOnly =
    zio.aws.rekognition.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateDatasetRequest =
      zio.aws.rekognition.model.CreateDatasetRequest(
        datasetSource.map(value => value.asEditable),
        datasetType,
        projectArn
      )
    def datasetSource: Option[zio.aws.rekognition.model.DatasetSource.ReadOnly]
    def datasetType: zio.aws.rekognition.model.DatasetType
    def projectArn: ProjectArn
    def getDatasetSource
        : ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetSource.ReadOnly] =
      AwsError.unwrapOptionField("datasetSource", datasetSource)
    def getDatasetType
        : ZIO[Any, Nothing, zio.aws.rekognition.model.DatasetType] =
      ZIO.succeed(datasetType)
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateDatasetRequest
  ) extends zio.aws.rekognition.model.CreateDatasetRequest.ReadOnly {
    override val datasetSource
        : Option[zio.aws.rekognition.model.DatasetSource.ReadOnly] = scala
      .Option(impl.datasetSource())
      .map(value => zio.aws.rekognition.model.DatasetSource.wrap(value))
    override val datasetType: zio.aws.rekognition.model.DatasetType =
      zio.aws.rekognition.model.DatasetType.wrap(impl.datasetType())
    override val projectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.projectArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateDatasetRequest
  ): zio.aws.rekognition.model.CreateDatasetRequest.ReadOnly = new Wrapper(impl)
}
