package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{TagValue, TagKey, CollectionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCollectionRequest(
    collectionId: CollectionId,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest = {
    import CreateCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CreateCollectionRequest.ReadOnly =
    zio.aws.rekognition.model.CreateCollectionRequest.wrap(buildAwsValue())
}
object CreateCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateCollectionRequest =
      zio.aws.rekognition.model
        .CreateCollectionRequest(collectionId, tags.map(value => value))
    def collectionId: CollectionId
    def tags: Option[Map[TagKey, TagValue]]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest
  ) extends zio.aws.rekognition.model.CreateCollectionRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.rekognition.model.primitives.TagKey(
              key
            ) -> zio.aws.rekognition.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest
  ): zio.aws.rekognition.model.CreateCollectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
