package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CelebrityRecognition(
    timestamp: Option[Timestamp] = None,
    celebrity: Option[zio.aws.rekognition.model.CelebrityDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CelebrityRecognition = {
    import CelebrityRecognition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CelebrityRecognition
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(celebrity.map(value => value.buildAwsValue()))(
        _.celebrity
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CelebrityRecognition.ReadOnly =
    zio.aws.rekognition.model.CelebrityRecognition.wrap(buildAwsValue())
}
object CelebrityRecognition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CelebrityRecognition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CelebrityRecognition =
      zio.aws.rekognition.model.CelebrityRecognition(
        timestamp.map(value => value),
        celebrity.map(value => value.asEditable)
      )
    def timestamp: Option[Timestamp]
    def celebrity: Option[zio.aws.rekognition.model.CelebrityDetail.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getCelebrity: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.CelebrityDetail.ReadOnly
    ] = AwsError.unwrapOptionField("celebrity", celebrity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CelebrityRecognition
  ) extends zio.aws.rekognition.model.CelebrityRecognition.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val celebrity
        : Option[zio.aws.rekognition.model.CelebrityDetail.ReadOnly] = scala
      .Option(impl.celebrity())
      .map(value => zio.aws.rekognition.model.CelebrityDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CelebrityRecognition
  ): zio.aws.rekognition.model.CelebrityRecognition.ReadOnly = new Wrapper(impl)
}
