package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.UInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AgeRange(
    low: Option[UInteger] = None,
    high: Option[UInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.AgeRange = {
    import AgeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.AgeRange
      .builder()
      .optionallyWith(low.map(value => UInteger.unwrap(value): Integer))(_.low)
      .optionallyWith(high.map(value => UInteger.unwrap(value): Integer))(
        _.high
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.AgeRange.ReadOnly =
    zio.aws.rekognition.model.AgeRange.wrap(buildAwsValue())
}
object AgeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.AgeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.AgeRange =
      zio.aws.rekognition.model
        .AgeRange(low.map(value => value), high.map(value => value))
    def low: Option[UInteger]
    def high: Option[UInteger]
    def getLow: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("low", low)
    def getHigh: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("high", high)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.AgeRange
  ) extends zio.aws.rekognition.model.AgeRange.ReadOnly {
    override val low: Option[UInteger] = scala
      .Option(impl.low())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val high: Option[UInteger] = scala
      .Option(impl.high())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.AgeRange
  ): zio.aws.rekognition.model.AgeRange.ReadOnly = new Wrapper(impl)
}
