package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ValidationData(
    assets: Option[Iterable[zio.aws.rekognition.model.Asset]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ValidationData = {
    import ValidationData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ValidationData
      .builder()
      .optionallyWith(
        assets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assets)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ValidationData.ReadOnly =
    zio.aws.rekognition.model.ValidationData.wrap(buildAwsValue())
}
object ValidationData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ValidationData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ValidationData =
      zio.aws.rekognition.model.ValidationData(
        assets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def assets: Option[List[zio.aws.rekognition.model.Asset.ReadOnly]]
    def getAssets
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Asset.ReadOnly]] =
      AwsError.unwrapOptionField("assets", assets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ValidationData
  ) extends zio.aws.rekognition.model.ValidationData.ReadOnly {
    override val assets
        : Option[List[zio.aws.rekognition.model.Asset.ReadOnly]] = scala
      .Option(impl.assets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Asset.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ValidationData
  ): zio.aws.rekognition.model.ValidationData.ReadOnly = new Wrapper(impl)
}
