package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectVersionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopProjectVersionRequest(
    projectVersionArn: ProjectVersionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest = {
    import StopProjectVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest
      .builder()
      .projectVersionArn(
        ProjectVersionArn.unwrap(projectVersionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StopProjectVersionRequest.ReadOnly =
    zio.aws.rekognition.model.StopProjectVersionRequest.wrap(buildAwsValue())
}
object StopProjectVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StopProjectVersionRequest =
      zio.aws.rekognition.model.StopProjectVersionRequest(projectVersionArn)
    def projectVersionArn: ProjectVersionArn
    def getProjectVersionArn: ZIO[Any, Nothing, ProjectVersionArn] =
      ZIO.succeed(projectVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest
  ) extends zio.aws.rekognition.model.StopProjectVersionRequest.ReadOnly {
    override val projectVersionArn: ProjectVersionArn =
      zio.aws.rekognition.model.primitives
        .ProjectVersionArn(impl.projectVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest
  ): zio.aws.rekognition.model.StopProjectVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
