package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartCelebrityRecognitionResponse(
    jobId: Option[JobId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse = {
    import StartCelebrityRecognitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly =
    zio.aws.rekognition.model.StartCelebrityRecognitionResponse
      .wrap(buildAwsValue())
}
object StartCelebrityRecognitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.StartCelebrityRecognitionResponse =
      zio.aws.rekognition.model
        .StartCelebrityRecognitionResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse
  ) extends zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse
  ): zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly =
    new Wrapper(impl)
}
