package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait ProjectStatus {
  def unwrap: software.amazon.awssdk.services.rekognition.model.ProjectStatus
}
object ProjectStatus {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.ProjectStatus
  ): zio.aws.rekognition.model.ProjectStatus = value match {
    case software.amazon.awssdk.services.rekognition.model.ProjectStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.rekognition.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectStatus.CREATING
  }
  case object CREATED extends zio.aws.rekognition.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectStatus.CREATED
  }
  case object DELETING extends zio.aws.rekognition.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectStatus.DELETING
  }
}
