package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{MaxResults, PaginationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStreamProcessorsRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest = {
    import ListStreamProcessorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ListStreamProcessorsRequest.ReadOnly =
    zio.aws.rekognition.model.ListStreamProcessorsRequest.wrap(buildAwsValue())
}
object ListStreamProcessorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListStreamProcessorsRequest =
      zio.aws.rekognition.model.ListStreamProcessorsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
  ) extends zio.aws.rekognition.model.ListStreamProcessorsRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
  ): zio.aws.rekognition.model.ListStreamProcessorsRequest.ReadOnly =
    new Wrapper(impl)
}
