package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Instance(
    boundingBox: Option[zio.aws.rekognition.model.BoundingBox] = None,
    confidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Instance
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Instance.ReadOnly =
    zio.aws.rekognition.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Instance =
      zio.aws.rekognition.model.Instance(
        boundingBox.map(value => value.asEditable),
        confidence.map(value => value)
      )
    def boundingBox: Option[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def confidence: Option[Percent]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Instance
  ) extends zio.aws.rekognition.model.Instance.ReadOnly {
    override val boundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly] = scala
      .Option(impl.boundingBox())
      .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Instance
  ): zio.aws.rekognition.model.Instance.ReadOnly = new Wrapper(impl)
}
