package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HumanLoopDataAttributes(
    contentClassifiers: Option[
      Iterable[zio.aws.rekognition.model.ContentClassifier]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.HumanLoopDataAttributes = {
    import HumanLoopDataAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.HumanLoopDataAttributes
      .builder()
      .optionallyWith(
        contentClassifiers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contentClassifiersWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.HumanLoopDataAttributes.ReadOnly =
    zio.aws.rekognition.model.HumanLoopDataAttributes.wrap(buildAwsValue())
}
object HumanLoopDataAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.HumanLoopDataAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.HumanLoopDataAttributes =
      zio.aws.rekognition.model
        .HumanLoopDataAttributes(contentClassifiers.map(value => value))
    def contentClassifiers
        : Option[List[zio.aws.rekognition.model.ContentClassifier]]
    def getContentClassifiers: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ContentClassifier
    ]] = AwsError.unwrapOptionField("contentClassifiers", contentClassifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.HumanLoopDataAttributes
  ) extends zio.aws.rekognition.model.HumanLoopDataAttributes.ReadOnly {
    override val contentClassifiers
        : Option[List[zio.aws.rekognition.model.ContentClassifier]] = scala
      .Option(impl.contentClassifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ContentClassifier.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.HumanLoopDataAttributes
  ): zio.aws.rekognition.model.HumanLoopDataAttributes.ReadOnly = new Wrapper(
    impl
  )
}
