package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFaceSearchResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    nextToken: Option[PaginationToken] = None,
    videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata] = None,
    persons: Option[Iterable[zio.aws.rekognition.model.PersonMatch]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse = {
    import GetFaceSearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        persons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.persons)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly =
    zio.aws.rekognition.model.GetFaceSearchResponse.wrap(buildAwsValue())
}
object GetFaceSearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetFaceSearchResponse =
      zio.aws.rekognition.model.GetFaceSearchResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        nextToken.map(value => value),
        videoMetadata.map(value => value.asEditable),
        persons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def nextToken: Option[PaginationToken]
    def videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def persons: Option[List[zio.aws.rekognition.model.PersonMatch.ReadOnly]]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getPersons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.PersonMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("persons", persons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
  ) extends zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val videoMetadata
        : Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly] = scala
      .Option(impl.videoMetadata())
      .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val persons
        : Option[List[zio.aws.rekognition.model.PersonMatch.ReadOnly]] = scala
      .Option(impl.persons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.PersonMatch.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
  ): zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly = new Wrapper(
    impl
  )
}
