package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFaceDetectionResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata] = None,
    nextToken: Option[PaginationToken] = None,
    faces: Option[Iterable[zio.aws.rekognition.model.FaceDetection]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse = {
    import GetFaceDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        faces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faces)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetFaceDetectionResponse.wrap(buildAwsValue())
}
object GetFaceDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetFaceDetectionResponse =
      zio.aws.rekognition.model.GetFaceDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        nextToken.map(value => value),
        faces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def nextToken: Option[PaginationToken]
    def faces: Option[List[zio.aws.rekognition.model.FaceDetection.ReadOnly]]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("faces", faces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
  ) extends zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly] = scala
      .Option(impl.videoMetadata())
      .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val faces
        : Option[List[zio.aws.rekognition.model.FaceDetection.ReadOnly]] = scala
      .Option(impl.faces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.FaceDetection.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
  ): zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
