package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FaceDetail(
    boundingBox: Option[zio.aws.rekognition.model.BoundingBox] = None,
    ageRange: Option[zio.aws.rekognition.model.AgeRange] = None,
    smile: Option[zio.aws.rekognition.model.Smile] = None,
    eyeglasses: Option[zio.aws.rekognition.model.Eyeglasses] = None,
    sunglasses: Option[zio.aws.rekognition.model.Sunglasses] = None,
    gender: Option[zio.aws.rekognition.model.Gender] = None,
    beard: Option[zio.aws.rekognition.model.Beard] = None,
    mustache: Option[zio.aws.rekognition.model.Mustache] = None,
    eyesOpen: Option[zio.aws.rekognition.model.EyeOpen] = None,
    mouthOpen: Option[zio.aws.rekognition.model.MouthOpen] = None,
    emotions: Option[Iterable[zio.aws.rekognition.model.Emotion]] = None,
    landmarks: Option[Iterable[zio.aws.rekognition.model.Landmark]] = None,
    pose: Option[zio.aws.rekognition.model.Pose] = None,
    quality: Option[zio.aws.rekognition.model.ImageQuality] = None,
    confidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.FaceDetail = {
    import FaceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.FaceDetail
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(ageRange.map(value => value.buildAwsValue()))(_.ageRange)
      .optionallyWith(smile.map(value => value.buildAwsValue()))(_.smile)
      .optionallyWith(eyeglasses.map(value => value.buildAwsValue()))(
        _.eyeglasses
      )
      .optionallyWith(sunglasses.map(value => value.buildAwsValue()))(
        _.sunglasses
      )
      .optionallyWith(gender.map(value => value.buildAwsValue()))(_.gender)
      .optionallyWith(beard.map(value => value.buildAwsValue()))(_.beard)
      .optionallyWith(mustache.map(value => value.buildAwsValue()))(_.mustache)
      .optionallyWith(eyesOpen.map(value => value.buildAwsValue()))(_.eyesOpen)
      .optionallyWith(mouthOpen.map(value => value.buildAwsValue()))(
        _.mouthOpen
      )
      .optionallyWith(
        emotions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emotions)
      .optionallyWith(
        landmarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.landmarks)
      .optionallyWith(pose.map(value => value.buildAwsValue()))(_.pose)
      .optionallyWith(quality.map(value => value.buildAwsValue()))(_.quality)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.FaceDetail.ReadOnly =
    zio.aws.rekognition.model.FaceDetail.wrap(buildAwsValue())
}
object FaceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.FaceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.FaceDetail =
      zio.aws.rekognition.model.FaceDetail(
        boundingBox.map(value => value.asEditable),
        ageRange.map(value => value.asEditable),
        smile.map(value => value.asEditable),
        eyeglasses.map(value => value.asEditable),
        sunglasses.map(value => value.asEditable),
        gender.map(value => value.asEditable),
        beard.map(value => value.asEditable),
        mustache.map(value => value.asEditable),
        eyesOpen.map(value => value.asEditable),
        mouthOpen.map(value => value.asEditable),
        emotions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        landmarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pose.map(value => value.asEditable),
        quality.map(value => value.asEditable),
        confidence.map(value => value)
      )
    def boundingBox: Option[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def ageRange: Option[zio.aws.rekognition.model.AgeRange.ReadOnly]
    def smile: Option[zio.aws.rekognition.model.Smile.ReadOnly]
    def eyeglasses: Option[zio.aws.rekognition.model.Eyeglasses.ReadOnly]
    def sunglasses: Option[zio.aws.rekognition.model.Sunglasses.ReadOnly]
    def gender: Option[zio.aws.rekognition.model.Gender.ReadOnly]
    def beard: Option[zio.aws.rekognition.model.Beard.ReadOnly]
    def mustache: Option[zio.aws.rekognition.model.Mustache.ReadOnly]
    def eyesOpen: Option[zio.aws.rekognition.model.EyeOpen.ReadOnly]
    def mouthOpen: Option[zio.aws.rekognition.model.MouthOpen.ReadOnly]
    def emotions: Option[List[zio.aws.rekognition.model.Emotion.ReadOnly]]
    def landmarks: Option[List[zio.aws.rekognition.model.Landmark.ReadOnly]]
    def pose: Option[zio.aws.rekognition.model.Pose.ReadOnly]
    def quality: Option[zio.aws.rekognition.model.ImageQuality.ReadOnly]
    def confidence: Option[Percent]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getAgeRange
        : ZIO[Any, AwsError, zio.aws.rekognition.model.AgeRange.ReadOnly] =
      AwsError.unwrapOptionField("ageRange", ageRange)
    def getSmile: ZIO[Any, AwsError, zio.aws.rekognition.model.Smile.ReadOnly] =
      AwsError.unwrapOptionField("smile", smile)
    def getEyeglasses
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Eyeglasses.ReadOnly] =
      AwsError.unwrapOptionField("eyeglasses", eyeglasses)
    def getSunglasses
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Sunglasses.ReadOnly] =
      AwsError.unwrapOptionField("sunglasses", sunglasses)
    def getGender
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Gender.ReadOnly] =
      AwsError.unwrapOptionField("gender", gender)
    def getBeard: ZIO[Any, AwsError, zio.aws.rekognition.model.Beard.ReadOnly] =
      AwsError.unwrapOptionField("beard", beard)
    def getMustache
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Mustache.ReadOnly] =
      AwsError.unwrapOptionField("mustache", mustache)
    def getEyesOpen
        : ZIO[Any, AwsError, zio.aws.rekognition.model.EyeOpen.ReadOnly] =
      AwsError.unwrapOptionField("eyesOpen", eyesOpen)
    def getMouthOpen
        : ZIO[Any, AwsError, zio.aws.rekognition.model.MouthOpen.ReadOnly] =
      AwsError.unwrapOptionField("mouthOpen", mouthOpen)
    def getEmotions
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Emotion.ReadOnly]] =
      AwsError.unwrapOptionField("emotions", emotions)
    def getLandmarks: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.Landmark.ReadOnly
    ]] = AwsError.unwrapOptionField("landmarks", landmarks)
    def getPose: ZIO[Any, AwsError, zio.aws.rekognition.model.Pose.ReadOnly] =
      AwsError.unwrapOptionField("pose", pose)
    def getQuality
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ImageQuality.ReadOnly] =
      AwsError.unwrapOptionField("quality", quality)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.FaceDetail
  ) extends zio.aws.rekognition.model.FaceDetail.ReadOnly {
    override val boundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly] = scala
      .Option(impl.boundingBox())
      .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val ageRange: Option[zio.aws.rekognition.model.AgeRange.ReadOnly] =
      scala
        .Option(impl.ageRange())
        .map(value => zio.aws.rekognition.model.AgeRange.wrap(value))
    override val smile: Option[zio.aws.rekognition.model.Smile.ReadOnly] = scala
      .Option(impl.smile())
      .map(value => zio.aws.rekognition.model.Smile.wrap(value))
    override val eyeglasses
        : Option[zio.aws.rekognition.model.Eyeglasses.ReadOnly] = scala
      .Option(impl.eyeglasses())
      .map(value => zio.aws.rekognition.model.Eyeglasses.wrap(value))
    override val sunglasses
        : Option[zio.aws.rekognition.model.Sunglasses.ReadOnly] = scala
      .Option(impl.sunglasses())
      .map(value => zio.aws.rekognition.model.Sunglasses.wrap(value))
    override val gender: Option[zio.aws.rekognition.model.Gender.ReadOnly] =
      scala
        .Option(impl.gender())
        .map(value => zio.aws.rekognition.model.Gender.wrap(value))
    override val beard: Option[zio.aws.rekognition.model.Beard.ReadOnly] = scala
      .Option(impl.beard())
      .map(value => zio.aws.rekognition.model.Beard.wrap(value))
    override val mustache: Option[zio.aws.rekognition.model.Mustache.ReadOnly] =
      scala
        .Option(impl.mustache())
        .map(value => zio.aws.rekognition.model.Mustache.wrap(value))
    override val eyesOpen: Option[zio.aws.rekognition.model.EyeOpen.ReadOnly] =
      scala
        .Option(impl.eyesOpen())
        .map(value => zio.aws.rekognition.model.EyeOpen.wrap(value))
    override val mouthOpen
        : Option[zio.aws.rekognition.model.MouthOpen.ReadOnly] = scala
      .Option(impl.mouthOpen())
      .map(value => zio.aws.rekognition.model.MouthOpen.wrap(value))
    override val emotions
        : Option[List[zio.aws.rekognition.model.Emotion.ReadOnly]] = scala
      .Option(impl.emotions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Emotion.wrap(item)
        }.toList
      )
    override val landmarks
        : Option[List[zio.aws.rekognition.model.Landmark.ReadOnly]] = scala
      .Option(impl.landmarks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Landmark.wrap(item)
        }.toList
      )
    override val pose: Option[zio.aws.rekognition.model.Pose.ReadOnly] = scala
      .Option(impl.pose())
      .map(value => zio.aws.rekognition.model.Pose.wrap(value))
    override val quality
        : Option[zio.aws.rekognition.model.ImageQuality.ReadOnly] = scala
      .Option(impl.quality())
      .map(value => zio.aws.rekognition.model.ImageQuality.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.FaceDetail
  ): zio.aws.rekognition.model.FaceDetail.ReadOnly = new Wrapper(impl)
}
