package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectTextResponse(
    textDetections: Option[Iterable[zio.aws.rekognition.model.TextDetection]] =
      None,
    textModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectTextResponse = {
    import DetectTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectTextResponse
      .builder()
      .optionallyWith(
        textDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textDetections)
      .optionallyWith(textModelVersion.map(value => value: java.lang.String))(
        _.textModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectTextResponse.ReadOnly =
    zio.aws.rekognition.model.DetectTextResponse.wrap(buildAwsValue())
}
object DetectTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectTextResponse =
      zio.aws.rekognition.model.DetectTextResponse(
        textDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        textModelVersion.map(value => value)
      )
    def textDetections
        : Option[List[zio.aws.rekognition.model.TextDetection.ReadOnly]]
    def textModelVersion: Option[String]
    def getTextDetections: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.TextDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("textDetections", textDetections)
    def getTextModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("textModelVersion", textModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextResponse
  ) extends zio.aws.rekognition.model.DetectTextResponse.ReadOnly {
    override val textDetections
        : Option[List[zio.aws.rekognition.model.TextDetection.ReadOnly]] = scala
      .Option(impl.textDetections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.TextDetection.wrap(item)
        }.toList
      )
    override val textModelVersion: Option[String] =
      scala.Option(impl.textModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextResponse
  ): zio.aws.rekognition.model.DetectTextResponse.ReadOnly = new Wrapper(impl)
}
