package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{Percent, UInteger}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectLabelsRequest(
    image: zio.aws.rekognition.model.Image,
    maxLabels: Option[UInteger] = None,
    minConfidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest = {
    import DetectLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
      .builder()
      .image(image.buildAwsValue())
      .optionallyWith(maxLabels.map(value => UInteger.unwrap(value): Integer))(
        _.maxLabels
      )
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsRequest.wrap(buildAwsValue())
}
object DetectLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsRequest =
      zio.aws.rekognition.model.DetectLabelsRequest(
        image.asEditable,
        maxLabels.map(value => value),
        minConfidence.map(value => value)
      )
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def maxLabels: Option[UInteger]
    def minConfidence: Option[Percent]
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getMaxLabels: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("maxLabels", maxLabels)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ) extends zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val maxLabels: Option[UInteger] = scala
      .Option(impl.maxLabels())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val minConfidence: Option[Percent] = scala
      .Option(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ): zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly = new Wrapper(impl)
}
