package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{
  ProjectName,
  ProjectsPageSize,
  ExtendedPaginationToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProjectsRequest(
    nextToken: Option[ExtendedPaginationToken] = None,
    maxResults: Option[ProjectsPageSize] = None,
    projectNames: Option[Iterable[ProjectName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest = {
    import DescribeProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ProjectsPageSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        projectNames.map(value =>
          value.map { item =>
            ProjectName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.projectNames)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DescribeProjectsRequest.ReadOnly =
    zio.aws.rekognition.model.DescribeProjectsRequest.wrap(buildAwsValue())
}
object DescribeProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeProjectsRequest =
      zio.aws.rekognition.model.DescribeProjectsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        projectNames.map(value => value)
      )
    def nextToken: Option[ExtendedPaginationToken]
    def maxResults: Option[ProjectsPageSize]
    def projectNames: Option[List[ProjectName]]
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ProjectsPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getProjectNames: ZIO[Any, AwsError, List[ProjectName]] =
      AwsError.unwrapOptionField("projectNames", projectNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest
  ) extends zio.aws.rekognition.model.DescribeProjectsRequest.ReadOnly {
    override val nextToken: Option[ExtendedPaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
      )
    override val maxResults: Option[ProjectsPageSize] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.rekognition.model.primitives.ProjectsPageSize(value)
      )
    override val projectNames: Option[List[ProjectName]] = scala
      .Option(impl.projectNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.ProjectName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest
  ): zio.aws.rekognition.model.DescribeProjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
