package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.GroundTruthBlob
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DatasetChanges(groundTruth: GroundTruthBlob) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetChanges = {
    import DatasetChanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetChanges
      .builder()
      .groundTruth(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(groundTruth.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetChanges.ReadOnly =
    zio.aws.rekognition.model.DatasetChanges.wrap(buildAwsValue())
}
object DatasetChanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetChanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetChanges =
      zio.aws.rekognition.model.DatasetChanges(groundTruth)
    def groundTruth: GroundTruthBlob
    def getGroundTruth: ZIO[Any, Nothing, GroundTruthBlob] =
      ZIO.succeed(groundTruth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetChanges
  ) extends zio.aws.rekognition.model.DatasetChanges.ReadOnly {
    override val groundTruth: GroundTruthBlob =
      zio.aws.rekognition.model.primitives.GroundTruthBlob(
        zio.Chunk.fromArray(impl.groundTruth().asByteArrayUnsafe())
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetChanges
  ): zio.aws.rekognition.model.DatasetChanges.ReadOnly = new Wrapper(impl)
}
