package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  TagValue,
  ProjectArn,
  KmsKeyId,
  VersionName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateProjectVersionRequest(
    projectArn: ProjectArn,
    versionName: VersionName,
    outputConfig: zio.aws.rekognition.model.OutputConfig,
    trainingData: Option[zio.aws.rekognition.model.TrainingData] = None,
    testingData: Option[zio.aws.rekognition.model.TestingData] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest = {
    import CreateProjectVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .versionName(VersionName.unwrap(versionName): java.lang.String)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(trainingData.map(value => value.buildAwsValue()))(
        _.trainingData
      )
      .optionallyWith(testingData.map(value => value.buildAwsValue()))(
        _.testingData
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateProjectVersionRequest.ReadOnly =
    zio.aws.rekognition.model.CreateProjectVersionRequest.wrap(buildAwsValue())
}
object CreateProjectVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateProjectVersionRequest =
      zio.aws.rekognition.model.CreateProjectVersionRequest(
        projectArn,
        versionName,
        outputConfig.asEditable,
        trainingData.map(value => value.asEditable),
        testingData.map(value => value.asEditable),
        tags.map(value => value),
        kmsKeyId.map(value => value)
      )
    def projectArn: ProjectArn
    def versionName: VersionName
    def outputConfig: zio.aws.rekognition.model.OutputConfig.ReadOnly
    def trainingData: Option[zio.aws.rekognition.model.TrainingData.ReadOnly]
    def testingData: Option[zio.aws.rekognition.model.TestingData.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def kmsKeyId: Option[KmsKeyId]
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getVersionName: ZIO[Any, Nothing, VersionName] =
      ZIO.succeed(versionName)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.rekognition.model.OutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getTrainingData
        : ZIO[Any, AwsError, zio.aws.rekognition.model.TrainingData.ReadOnly] =
      AwsError.unwrapOptionField("trainingData", trainingData)
    def getTestingData
        : ZIO[Any, AwsError, zio.aws.rekognition.model.TestingData.ReadOnly] =
      AwsError.unwrapOptionField("testingData", testingData)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest
  ) extends zio.aws.rekognition.model.CreateProjectVersionRequest.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.projectArn())
    override val versionName: VersionName =
      zio.aws.rekognition.model.primitives.VersionName(impl.versionName())
    override val outputConfig: zio.aws.rekognition.model.OutputConfig.ReadOnly =
      zio.aws.rekognition.model.OutputConfig.wrap(impl.outputConfig())
    override val trainingData
        : Option[zio.aws.rekognition.model.TrainingData.ReadOnly] = scala
      .Option(impl.trainingData())
      .map(value => zio.aws.rekognition.model.TrainingData.wrap(value))
    override val testingData
        : Option[zio.aws.rekognition.model.TestingData.ReadOnly] = scala
      .Option(impl.testingData())
      .map(value => zio.aws.rekognition.model.TestingData.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.rekognition.model.primitives.TagKey(
              key
            ) -> zio.aws.rekognition.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.rekognition.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest
  ): zio.aws.rekognition.model.CreateProjectVersionRequest.ReadOnly =
    new Wrapper(impl)
}
