package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait VideoColorRange {
  def unwrap: software.amazon.awssdk.services.rekognition.model.VideoColorRange
}
object VideoColorRange {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.VideoColorRange
  ): zio.aws.rekognition.model.VideoColorRange = value match {
    case software.amazon.awssdk.services.rekognition.model.VideoColorRange.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.VideoColorRange.FULL =>
      val r = FULL
      r
    case software.amazon.awssdk.services.rekognition.model.VideoColorRange.LIMITED =>
      val r = LIMITED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.VideoColorRange {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.VideoColorRange =
      software.amazon.awssdk.services.rekognition.model.VideoColorRange.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL extends zio.aws.rekognition.model.VideoColorRange {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.VideoColorRange =
      software.amazon.awssdk.services.rekognition.model.VideoColorRange.FULL
  }
  case object LIMITED extends zio.aws.rekognition.model.VideoColorRange {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.VideoColorRange =
      software.amazon.awssdk.services.rekognition.model.VideoColorRange.LIMITED
  }
}
