package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnindexedFace(
    reasons: Option[Iterable[zio.aws.rekognition.model.Reason]] = None,
    faceDetail: Option[zio.aws.rekognition.model.FaceDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.UnindexedFace = {
    import UnindexedFace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.UnindexedFace
      .builder()
      .optionallyWith(
        reasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reasonsWithStrings)
      .optionallyWith(faceDetail.map(value => value.buildAwsValue()))(
        _.faceDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.UnindexedFace.ReadOnly =
    zio.aws.rekognition.model.UnindexedFace.wrap(buildAwsValue())
}
object UnindexedFace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.UnindexedFace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.UnindexedFace =
      zio.aws.rekognition.model.UnindexedFace(
        reasons.map(value => value),
        faceDetail.map(value => value.asEditable)
      )
    def reasons: Option[List[zio.aws.rekognition.model.Reason]]
    def faceDetail: Option[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def getReasons: ZIO[Any, AwsError, List[zio.aws.rekognition.model.Reason]] =
      AwsError.unwrapOptionField("reasons", reasons)
    def getFaceDetail
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("faceDetail", faceDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.UnindexedFace
  ) extends zio.aws.rekognition.model.UnindexedFace.ReadOnly {
    override val reasons: Option[List[zio.aws.rekognition.model.Reason]] = scala
      .Option(impl.reasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Reason.wrap(item)
        }.toList
      )
    override val faceDetail
        : Option[zio.aws.rekognition.model.FaceDetail.ReadOnly] = scala
      .Option(impl.faceDetail())
      .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.UnindexedFace
  ): zio.aws.rekognition.model.UnindexedFace.ReadOnly = new Wrapper(impl)
}
