package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait StreamProcessorStatus {
  def unwrap
      : software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus
}
object StreamProcessorStatus {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus
  ): zio.aws.rekognition.model.StreamProcessorStatus = value match {
    case software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.STOPPING =>
      val r = STOPPING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.StreamProcessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus =
      software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STOPPED extends zio.aws.rekognition.model.StreamProcessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus =
      software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.STOPPED
  }
  case object STARTING extends zio.aws.rekognition.model.StreamProcessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus =
      software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.STARTING
  }
  case object RUNNING extends zio.aws.rekognition.model.StreamProcessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus =
      software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.RUNNING
  }
  case object FAILED extends zio.aws.rekognition.model.StreamProcessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus =
      software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.FAILED
  }
  case object STOPPING extends zio.aws.rekognition.model.StreamProcessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus =
      software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus.STOPPING
  }
}
