package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartContentModerationResponse(jobId: Option[JobId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse = {
    import StartContentModerationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly =
    zio.aws.rekognition.model.StartContentModerationResponse
      .wrap(buildAwsValue())
}
object StartContentModerationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartContentModerationResponse =
      zio.aws.rekognition.model
        .StartContentModerationResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse
  ) extends zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse
  ): zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly =
    new Wrapper(impl)
}
