package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchFacesByImageResponse(
    searchedFaceBoundingBox: Option[zio.aws.rekognition.model.BoundingBox] =
      None,
    searchedFaceConfidence: Option[Percent] = None,
    faceMatches: Option[Iterable[zio.aws.rekognition.model.FaceMatch]] = None,
    faceModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse = {
    import SearchFacesByImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
      .builder()
      .optionallyWith(
        searchedFaceBoundingBox.map(value => value.buildAwsValue())
      )(_.searchedFaceBoundingBox)
      .optionallyWith(
        searchedFaceConfidence.map(value =>
          Percent.unwrap(value): java.lang.Float
        )
      )(_.searchedFaceConfidence)
      .optionallyWith(
        faceMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceMatches)
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly =
    zio.aws.rekognition.model.SearchFacesByImageResponse.wrap(buildAwsValue())
}
object SearchFacesByImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchFacesByImageResponse =
      zio.aws.rekognition.model.SearchFacesByImageResponse(
        searchedFaceBoundingBox.map(value => value.asEditable),
        searchedFaceConfidence.map(value => value),
        faceMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        faceModelVersion.map(value => value)
      )
    def searchedFaceBoundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def searchedFaceConfidence: Option[Percent]
    def faceMatches: Option[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]]
    def faceModelVersion: Option[String]
    def getSearchedFaceBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField(
        "searchedFaceBoundingBox",
        searchedFaceBoundingBox
      )
    def getSearchedFaceConfidence: ZIO[Any, AwsError, Percent] = AwsError
      .unwrapOptionField("searchedFaceConfidence", searchedFaceConfidence)
    def getFaceMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("faceMatches", faceMatches)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
  ) extends zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly {
    override val searchedFaceBoundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly] = scala
      .Option(impl.searchedFaceBoundingBox())
      .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val searchedFaceConfidence: Option[Percent] = scala
      .Option(impl.searchedFaceConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val faceMatches
        : Option[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]] = scala
      .Option(impl.faceMatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.FaceMatch.wrap(item)
        }.toList
      )
    override val faceModelVersion: Option[String] =
      scala.Option(impl.faceModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
  ): zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly =
    new Wrapper(impl)
}
