package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{Percent, MaxFaces, CollectionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchFacesByImageRequest(
    collectionId: CollectionId,
    image: zio.aws.rekognition.model.Image,
    maxFaces: Option[MaxFaces] = None,
    faceMatchThreshold: Option[Percent] = None,
    qualityFilter: Option[zio.aws.rekognition.model.QualityFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest = {
    import SearchFacesByImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .image(image.buildAwsValue())
      .optionallyWith(maxFaces.map(value => MaxFaces.unwrap(value): Integer))(
        _.maxFaces
      )
      .optionallyWith(
        faceMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.faceMatchThreshold)
      .optionallyWith(qualityFilter.map(value => value.unwrap))(_.qualityFilter)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchFacesByImageRequest.ReadOnly =
    zio.aws.rekognition.model.SearchFacesByImageRequest.wrap(buildAwsValue())
}
object SearchFacesByImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchFacesByImageRequest =
      zio.aws.rekognition.model.SearchFacesByImageRequest(
        collectionId,
        image.asEditable,
        maxFaces.map(value => value),
        faceMatchThreshold.map(value => value),
        qualityFilter.map(value => value)
      )
    def collectionId: CollectionId
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def maxFaces: Option[MaxFaces]
    def faceMatchThreshold: Option[Percent]
    def qualityFilter: Option[zio.aws.rekognition.model.QualityFilter]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getMaxFaces: ZIO[Any, AwsError, MaxFaces] =
      AwsError.unwrapOptionField("maxFaces", maxFaces)
    def getFaceMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("faceMatchThreshold", faceMatchThreshold)
    def getQualityFilter
        : ZIO[Any, AwsError, zio.aws.rekognition.model.QualityFilter] =
      AwsError.unwrapOptionField("qualityFilter", qualityFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
  ) extends zio.aws.rekognition.model.SearchFacesByImageRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val maxFaces: Option[MaxFaces] = scala
      .Option(impl.maxFaces())
      .map(value => zio.aws.rekognition.model.primitives.MaxFaces(value))
    override val faceMatchThreshold: Option[Percent] = scala
      .Option(impl.faceMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val qualityFilter
        : Option[zio.aws.rekognition.model.QualityFilter] = scala
      .Option(impl.qualityFilter())
      .map(value => zio.aws.rekognition.model.QualityFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
  ): zio.aws.rekognition.model.SearchFacesByImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
