package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{FlowDefinitionArn, HumanLoopName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HumanLoopConfig(
    humanLoopName: HumanLoopName,
    flowDefinitionArn: FlowDefinitionArn,
    dataAttributes: Option[zio.aws.rekognition.model.HumanLoopDataAttributes] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.HumanLoopConfig = {
    import HumanLoopConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.HumanLoopConfig
      .builder()
      .humanLoopName(HumanLoopName.unwrap(humanLoopName): java.lang.String)
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .optionallyWith(dataAttributes.map(value => value.buildAwsValue()))(
        _.dataAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.HumanLoopConfig.ReadOnly =
    zio.aws.rekognition.model.HumanLoopConfig.wrap(buildAwsValue())
}
object HumanLoopConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.HumanLoopConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.HumanLoopConfig =
      zio.aws.rekognition.model.HumanLoopConfig(
        humanLoopName,
        flowDefinitionArn,
        dataAttributes.map(value => value.asEditable)
      )
    def humanLoopName: HumanLoopName
    def flowDefinitionArn: FlowDefinitionArn
    def dataAttributes
        : Option[zio.aws.rekognition.model.HumanLoopDataAttributes.ReadOnly]
    def getHumanLoopName: ZIO[Any, Nothing, HumanLoopName] =
      ZIO.succeed(humanLoopName)
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getDataAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.HumanLoopDataAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dataAttributes", dataAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.HumanLoopConfig
  ) extends zio.aws.rekognition.model.HumanLoopConfig.ReadOnly {
    override val humanLoopName: HumanLoopName =
      zio.aws.rekognition.model.primitives.HumanLoopName(impl.humanLoopName())
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.rekognition.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val dataAttributes
        : Option[zio.aws.rekognition.model.HumanLoopDataAttributes.ReadOnly] =
      scala
        .Option(impl.dataAttributes())
        .map(value =>
          zio.aws.rekognition.model.HumanLoopDataAttributes.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.HumanLoopConfig
  ): zio.aws.rekognition.model.HumanLoopConfig.ReadOnly = new Wrapper(impl)
}
