package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPersonTrackingResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata] = None,
    nextToken: Option[PaginationToken] = None,
    persons: Option[Iterable[zio.aws.rekognition.model.PersonDetection]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse = {
    import GetPersonTrackingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        persons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.persons)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly =
    zio.aws.rekognition.model.GetPersonTrackingResponse.wrap(buildAwsValue())
}
object GetPersonTrackingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetPersonTrackingResponse =
      zio.aws.rekognition.model.GetPersonTrackingResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        nextToken.map(value => value),
        persons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def nextToken: Option[PaginationToken]
    def persons
        : Option[List[zio.aws.rekognition.model.PersonDetection.ReadOnly]]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPersons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.PersonDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("persons", persons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
  ) extends zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly] = scala
      .Option(impl.videoMetadata())
      .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val persons
        : Option[List[zio.aws.rekognition.model.PersonDetection.ReadOnly]] =
      scala
        .Option(impl.persons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.PersonDetection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
  ): zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly = new Wrapper(
    impl
  )
}
