package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCelebrityRecognitionResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata] = None,
    nextToken: Option[PaginationToken] = None,
    celebrities: Option[
      Iterable[zio.aws.rekognition.model.CelebrityRecognition]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse = {
    import GetCelebrityRecognitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        celebrities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.celebrities)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly =
    zio.aws.rekognition.model.GetCelebrityRecognitionResponse
      .wrap(buildAwsValue())
}
object GetCelebrityRecognitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetCelebrityRecognitionResponse =
      zio.aws.rekognition.model.GetCelebrityRecognitionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        nextToken.map(value => value),
        celebrities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def nextToken: Option[PaginationToken]
    def celebrities
        : Option[List[zio.aws.rekognition.model.CelebrityRecognition.ReadOnly]]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCelebrities: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.CelebrityRecognition.ReadOnly
    ]] = AwsError.unwrapOptionField("celebrities", celebrities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse
  ) extends zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly] = scala
      .Option(impl.videoMetadata())
      .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val celebrities: Option[
      List[zio.aws.rekognition.model.CelebrityRecognition.ReadOnly]
    ] = scala
      .Option(impl.celebrities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.CelebrityRecognition.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse
  ): zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly =
    new Wrapper(impl)
}
