package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EquipmentDetection(
    boundingBox: Option[zio.aws.rekognition.model.BoundingBox] = None,
    confidence: Option[Percent] = None,
    `type`: Option[zio.aws.rekognition.model.ProtectiveEquipmentType] = None,
    coversBodyPart: Option[zio.aws.rekognition.model.CoversBodyPart] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.EquipmentDetection = {
    import EquipmentDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.EquipmentDetection
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(coversBodyPart.map(value => value.buildAwsValue()))(
        _.coversBodyPart
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.EquipmentDetection.ReadOnly =
    zio.aws.rekognition.model.EquipmentDetection.wrap(buildAwsValue())
}
object EquipmentDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.EquipmentDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.EquipmentDetection =
      zio.aws.rekognition.model.EquipmentDetection(
        boundingBox.map(value => value.asEditable),
        confidence.map(value => value),
        `type`.map(value => value),
        coversBodyPart.map(value => value.asEditable)
      )
    def boundingBox: Option[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def confidence: Option[Percent]
    def `type`: Option[zio.aws.rekognition.model.ProtectiveEquipmentType]
    def coversBodyPart
        : Option[zio.aws.rekognition.model.CoversBodyPart.ReadOnly]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ProtectiveEquipmentType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getCoversBodyPart: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.CoversBodyPart.ReadOnly
    ] = AwsError.unwrapOptionField("coversBodyPart", coversBodyPart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.EquipmentDetection
  ) extends zio.aws.rekognition.model.EquipmentDetection.ReadOnly {
    override val boundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly] = scala
      .Option(impl.boundingBox())
      .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val `type`
        : Option[zio.aws.rekognition.model.ProtectiveEquipmentType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.rekognition.model.ProtectiveEquipmentType.wrap(value)
      )
    override val coversBodyPart
        : Option[zio.aws.rekognition.model.CoversBodyPart.ReadOnly] = scala
      .Option(impl.coversBodyPart())
      .map(value => zio.aws.rekognition.model.CoversBodyPart.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.EquipmentDetection
  ): zio.aws.rekognition.model.EquipmentDetection.ReadOnly = new Wrapper(impl)
}
