package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectModerationLabelsRequest(
    image: zio.aws.rekognition.model.Image,
    minConfidence: Option[Percent] = None,
    humanLoopConfig: Option[zio.aws.rekognition.model.HumanLoopConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest = {
    import DetectModerationLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest
      .builder()
      .image(image.buildAwsValue())
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .optionallyWith(humanLoopConfig.map(value => value.buildAwsValue()))(
        _.humanLoopConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectModerationLabelsRequest.ReadOnly =
    zio.aws.rekognition.model.DetectModerationLabelsRequest
      .wrap(buildAwsValue())
}
object DetectModerationLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectModerationLabelsRequest =
      zio.aws.rekognition.model.DetectModerationLabelsRequest(
        image.asEditable,
        minConfidence.map(value => value),
        humanLoopConfig.map(value => value.asEditable)
      )
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def minConfidence: Option[Percent]
    def humanLoopConfig
        : Option[zio.aws.rekognition.model.HumanLoopConfig.ReadOnly]
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
    def getHumanLoopConfig: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.HumanLoopConfig.ReadOnly
    ] = AwsError.unwrapOptionField("humanLoopConfig", humanLoopConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest
  ) extends zio.aws.rekognition.model.DetectModerationLabelsRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val minConfidence: Option[Percent] = scala
      .Option(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val humanLoopConfig
        : Option[zio.aws.rekognition.model.HumanLoopConfig.ReadOnly] = scala
      .Option(impl.humanLoopConfig())
      .map(value => zio.aws.rekognition.model.HumanLoopConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest
  ): zio.aws.rekognition.model.DetectModerationLabelsRequest.ReadOnly =
    new Wrapper(impl)
}
