package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectVersionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProjectVersionRequest(
    projectVersionArn: ProjectVersionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionRequest = {
    import DeleteProjectVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionRequest
      .builder()
      .projectVersionArn(
        ProjectVersionArn.unwrap(projectVersionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DeleteProjectVersionRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteProjectVersionRequest.wrap(buildAwsValue())
}
object DeleteProjectVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteProjectVersionRequest =
      zio.aws.rekognition.model.DeleteProjectVersionRequest(projectVersionArn)
    def projectVersionArn: ProjectVersionArn
    def getProjectVersionArn: ZIO[Any, Nothing, ProjectVersionArn] =
      ZIO.succeed(projectVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionRequest
  ) extends zio.aws.rekognition.model.DeleteProjectVersionRequest.ReadOnly {
    override val projectVersionArn: ProjectVersionArn =
      zio.aws.rekognition.model.primitives
        .ProjectVersionArn(impl.projectVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionRequest
  ): zio.aws.rekognition.model.DeleteProjectVersionRequest.ReadOnly =
    new Wrapper(impl)
}
