package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait DatasetStatusMessageCode {
  def unwrap: software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode
}
object DatasetStatusMessageCode {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode
  ): zio.aws.rekognition.model.DatasetStatusMessageCode = value match {
    case software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.SERVICE_ERROR =>
      val r = SERVICE_ERROR
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.CLIENT_ERROR =>
      val r = CLIENT_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.DatasetStatusMessageCode {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode =
      software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS
      extends zio.aws.rekognition.model.DatasetStatusMessageCode {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode =
      software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.SUCCESS
  }
  case object SERVICE_ERROR
      extends zio.aws.rekognition.model.DatasetStatusMessageCode {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode =
      software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.SERVICE_ERROR
  }
  case object CLIENT_ERROR
      extends zio.aws.rekognition.model.DatasetStatusMessageCode {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode =
      software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode.CLIENT_ERROR
  }
}
