package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.UInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DatasetStats(
    labeledEntries: Option[UInteger] = None,
    totalEntries: Option[UInteger] = None,
    totalLabels: Option[UInteger] = None,
    errorEntries: Option[UInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetStats = {
    import DatasetStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetStats
      .builder()
      .optionallyWith(
        labeledEntries.map(value => UInteger.unwrap(value): Integer)
      )(_.labeledEntries)
      .optionallyWith(
        totalEntries.map(value => UInteger.unwrap(value): Integer)
      )(_.totalEntries)
      .optionallyWith(
        totalLabels.map(value => UInteger.unwrap(value): Integer)
      )(_.totalLabels)
      .optionallyWith(
        errorEntries.map(value => UInteger.unwrap(value): Integer)
      )(_.errorEntries)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetStats.ReadOnly =
    zio.aws.rekognition.model.DatasetStats.wrap(buildAwsValue())
}
object DatasetStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetStats =
      zio.aws.rekognition.model.DatasetStats(
        labeledEntries.map(value => value),
        totalEntries.map(value => value),
        totalLabels.map(value => value),
        errorEntries.map(value => value)
      )
    def labeledEntries: Option[UInteger]
    def totalEntries: Option[UInteger]
    def totalLabels: Option[UInteger]
    def errorEntries: Option[UInteger]
    def getLabeledEntries: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("labeledEntries", labeledEntries)
    def getTotalEntries: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("totalEntries", totalEntries)
    def getTotalLabels: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("totalLabels", totalLabels)
    def getErrorEntries: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("errorEntries", errorEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetStats
  ) extends zio.aws.rekognition.model.DatasetStats.ReadOnly {
    override val labeledEntries: Option[UInteger] = scala
      .Option(impl.labeledEntries())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val totalEntries: Option[UInteger] = scala
      .Option(impl.totalEntries())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val totalLabels: Option[UInteger] = scala
      .Option(impl.totalLabels())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val errorEntries: Option[UInteger] = scala
      .Option(impl.errorEntries())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetStats
  ): zio.aws.rekognition.model.DatasetStats.ReadOnly = new Wrapper(impl)
}
